﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    Private Sub btnValidate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnValidate.Click
        '用于依次通过窗体上的所有控件。
        Dim existingControl As Control

        '保存要向用户显示的消息，该消息指示
        '控件是否包含有效输入。
        Dim validationMessage As String = String.Empty

        '依次通过窗体上的所有控件。
        For Each existingControl In Controls
            '如果当前控件继承 RegExTextBox
            If TypeOf existingControl Is RegExTextBox Then
                '将其从 existingControl 类型强制转换为 RegExTextBox 类型。
                '这样，您就可以访问 IsValid 属性。
                Dim regexControl As RegExTextBox = CType(existingControl, RegExTextBox)

                '如果控件中的文本不正确，则将此控件添加
                '到无效控件列表中。
                If Not regexControl.IsValid Then
                    validationMessage &= regexControl.Name & ":" & _
                      regexControl.ErrorMessage & vbCrLf
                End If
            End If
        Next

        '这些控件是否包含无效文本？
        If validationMessage <> "" Then
            '在文本框中列出这些控件。
            txtInvalidControls.Text = "The following controls have invalid values: " _
                & vbCrLf & validationMessage
        Else
            '否则，指示一切正常。
            txtInvalidControls.Text = "All controls contain valid input."
        End If
    End Sub

    Private Sub mskIPAddress_Leave(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mskIPAddress.Leave
        lblIPAddress.Text = mskIPAddress.Text
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
